﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using TMPro;
using UnityEngine;
using UnityEngine.EventSystems;
using UnityEngine.UI;

public class IntermissionPhase : GamePhase
{
    public override void OnStartCurrentPhase()
    {
        //Disable the game updating and pausing and setup the UI
        Time.timeScale = 0.0f;
        PauseMenu.CanPause = false;
        GameController.Instance.Timer.GetComponent<Animator>().Play("TimerTick", 0, 0);
        GameController.Instance.Timer.GetComponent<Animator>().enabled = false;
        GameController.Instance.Timer.SetActive(false);
        GameController.Instance.ReadyScreen.SetActive(true);
        GameController.Instance.ReadyScreen.GetComponent<ReadyMenu>().MoveToThis(false);

        //Set the time for the seeker
        MapScroller.PlayerObject = GameController.Instance.SeekerPlayerObject;
        GameController.Instance.SetRoundTime(Constants.PlayerRole.Seeker);

        //Intermission, pop back to the spawn
        GameController.Instance.PlayerVirtualCamera.BlendTo(GameController.Instance.SpawnVirtualCamera);
    }

    public override void Update()
    {

    }

    public override void OnEndCurrentPhase()
    {

    }
}
